import React from "react";
import { motion } from "framer-motion";

export default function ProgressBar({ value = 0, max = 1 }) {
  const pct = Math.round(Math.min(100, (value / Math.max(1, max)) * 100));
  return (
    <div className="w-full bg-white/6 h-3 rounded overflow-hidden card-shadow">
      <motion.div
        className="h-3 bg-gradient-to-r from-cyan-400 to-violet-500"
        initial={{ width: 0 }}
        animate={{ width: `${pct}%` }}
      />
    </div>
  );
}
